﻿using System.Drawing;

namespace WindowsFormsApplication1 {
    public static class PrintDrawerTest {
        /// <summary>
        /// 1物理ページごとに印刷内容を出力するクラス（テストページ）
        /// </summary>
        static int marginL;
        static int marginT;
        static int printAreaW;
        static int printAreaH;
        static float hardMarginX;
        static float hardMarginY;
        static float printerMarginL;
        static float printerMarginT;

        static Font printFont = new Font("メイリオ", 11, FontStyle.Regular);

        public static bool printDrawer(System.Drawing.Printing.PrintPageEventArgs e, int printPageCount) {
            if(printPageCount == 1) {
                marginL = PrintArea.marginL;
                marginT = PrintArea.marginT;
                printAreaW = PrintArea.printAreaW;
                printAreaH = PrintArea.printAreaH;
                hardMarginX = PrintArea.hardMarginX;
                hardMarginY = PrintArea.hardMarginY;
                printerMarginL = PrintArea.printerMarginL;
                printerMarginT = PrintArea.printerMarginT;
            }

            //印刷内容生成
            e.Graphics.DrawRectangle(new Pen(Color.LightGray, 1F), printerMarginL, printerMarginT, printAreaW, printAreaH);
            e.Graphics.DrawString(printPageCount + "ページ", printFont, Brushes.Black, printerMarginL, printerMarginT);
            e.Graphics.DrawString("印刷範囲:" + printAreaW * 0.254 + "x" + printAreaH * 0.254 + "mm", printFont, Brushes.Black, printerMarginL, printerMarginT + (float)(10 / 25.4 * 100));
            e.Graphics.DrawString("マージン L:" + marginL * 0.254 + "mm　T:" + marginT * 0.254 + "mm", printFont, Brushes.Black, printerMarginL, printerMarginT + (float)(20 / 25.4 * 100));
            e.Graphics.DrawString("ハードマージン X:" + hardMarginX * 0.254 + "mm　Y:" + hardMarginY * 0.254 + "mm", printFont, Brushes.Black, printerMarginL, printerMarginT + (float)(30 / 25.4 * 100));

            //最終ページ判定
            if(printPageCount >= 5) {
                return false;
            }
            else {
                return true;
            }
        }
    }
}
