﻿using System;
using System.Collections.Generic;
using System.Data.SQLite;
using System.Drawing;
using System.Windows.Forms;

namespace WindowsFormsApplication1 {
    public partial class Form8SelectPrintForm : Form {
        public Form8SelectPrintForm() {
            InitializeComponent();
        }


        public DataGridView dataGridView1 { get; set; }
        public ComboBox comboBox1 { get; set; }
        public ComboBox comboBox2 { get; set; }




        //ロード完了時イベント
        private void Form8SelectPrintForm_Load(object sender, EventArgs e) {
            makeInputForm();
        }




        //入力フォーム作成
        private void makeInputForm() {
            Button newButton1 = new Button();
            newButton1.Name = "all";
            newButton1.Text = "全列";
            newButton1.Size = new Size(85, 25);
            newButton1.BackColor = Color.FromArgb(200, 220, 240);
            newButton1.Font = new Font("メイリオ", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            newButton1.Top = 80;
            newButton1.Left = 9;
            newButton1.Click += new EventHandler(selectButtonClick);

            this.Controls.Add(newButton1);

            Label newLabel1 = new Label();
            newLabel1.Text = "全ての列を印刷します";
            newLabel1.Font = new Font("メイリオ", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            newLabel1.AutoSize = true;
            newLabel1.Top = 84;
            newLabel1.Left = 100;

            this.Controls.Add(newLabel1);

            Button newButton2 = new Button();
            newButton2.Name = "visible";
            newButton2.Text = "画面表示列";
            newButton2.Size = new Size(85, 25);
            newButton2.BackColor = Color.FromArgb(200, 220, 240);
            newButton2.Font = new Font("メイリオ", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            newButton2.Top = 110;
            newButton2.Left = 9;
            newButton2.Click += new EventHandler(selectButtonClick);

            this.Controls.Add(newButton2);

            Label newLabel2 = new Label();
            newLabel2.Text = "画面に表示されている列を印刷します";
            newLabel2.Font = new Font("メイリオ", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            newLabel2.AutoSize = true;
            newLabel2.Top = 114;
            newLabel2.Left = 100;

            this.Controls.Add(newLabel2);

            for(int i = 0; i < 10; i++) {
                Button newButton = new Button();
                newButton.Name = "printform" + (i + 1).ToString();
                newButton.Text = "帳票" + (i + 1).ToString();
                newButton.Size = new Size(85, 25);
                newButton.BackColor = Color.FromArgb(200, 220, 240);
                newButton.Font = new Font("メイリオ", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
                newButton.Top = i * 30 + 140;
                newButton.Left = 9;
                newButton.Click += new EventHandler(selectButtonClick);

                this.Controls.Add(newButton);
            }

            FunctionForDatabase.setPrintFormRow();

            using(var con = new SQLiteConnection(DataBaseConfig.ConnectionString)) {
                con.Open();

                using(var cmd = con.CreateCommand()) {
                    cmd.CommandText = "SELECT form_no, name FROM print_form_setting ORDER BY form_no;";

                    using(var reader = cmd.ExecuteReader()) {
                        while(reader.Read()) {
                            int form_no = reader.GetInt32(0);
                            string name = reader.GetString(1);

                            Label newLabel = new Label();
                            newLabel.Text = name;
                            newLabel.Font = new Font("メイリオ", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
                            newLabel.AutoSize = true;
                            newLabel.Top = (form_no - 1) * 30 + 145;
                            newLabel.Left = 100;

                            this.Controls.Add(newLabel);
                        }
                    }
                }
            }
        }




        //帳票選択ボタンクリックイベント
        private void selectButtonClick(object sender, EventArgs e) {
            Button b = (Button)sender;
            string printFrom = b.Name;

            printPreviewForm(printFrom);
        }




        //印刷プレビューの表示
        private void printPreviewForm(string printFrom) {
            PrintContainer.printType = "Datalist";
            PrintContainer.dataGridView1 = dataGridView1;
            PrintContainer.comboBox1 = comboBox1;
            PrintContainer.comboBox2 = comboBox2;

            List<int> printColumnsNo = new List<int>();
            int printWidth = 0;

            if(printFrom == "all") {
                int j = 0;
                foreach(DataGridViewColumn column in dataGridView1.Columns) {
                    if(column.Name != "id" && column.Name != "kanrisya" && column.Name != "syorijou") {
                        printColumnsNo.Add(j);
                        printWidth += column.Width;
                    }

                    j++;
                }
            }
            else {
                int j = 0;
                foreach(DataGridViewColumn column in dataGridView1.Columns) {
                    if(column.Name == "sokutei_dt") {
                        printColumnsNo.Add(j);
                        printWidth += column.Width;
                    }
                    else if(column.Name != "id" && column.Name != "kanrisya" && column.Name != "syorijou") {
                        using(var con = new SQLiteConnection(DataBaseConfig.ConnectionString)) {
                            con.Open();

                            using(var cmd = con.CreateCommand()) {

                                cmd.CommandText = "SELECT " + printFrom + " FROM suishitsu_kanri_setting WHERE column_name='" + column.Name + "';";
                                
                                using(var reader = cmd.ExecuteReader()) {
                                    if(reader.Read()) {
                                        if(!reader.IsDBNull(0)) {
                                            if(reader.GetInt32(0) == 1) {
                                                printColumnsNo.Add(j);
                                                printWidth += column.Width;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    j++;
                }
            }

            PrintContainer.printColumnsNo = printColumnsNo;
            PrintContainer.printWidth = printWidth;

            var win = new Form3printPreview();
            win.Owner = this;

            if(this.WindowState == FormWindowState.Maximized) {
                int screenHeight = Screen.PrimaryScreen.WorkingArea.Height;
                int screenWidth = Screen.PrimaryScreen.WorkingArea.Width;
                win.Height = screenHeight;
                win.Width = screenWidth;
            }
            else {
                int mainWindowHeight = this.Size.Height;
                int mainWindowWidth = this.Size.Width;
                win.Height = mainWindowHeight;
                win.Width = mainWindowWidth;
            }

            win.StartPosition = FormStartPosition.CenterParent;
            win.ShowDialog();
        }




        //キャンセルボタンクリックイベント
        private void button2_Click(object sender, EventArgs e) {
            this.Close();
        }

    }
}
