﻿// 下水データ管理システム
// Copyright (C) 2018 公益財団法人とちぎ建設技術センター(https://www.tochigictc.or.jp/)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.If not, see<http://www.gnu.org/licenses/>.

using System.Reflection;
using System.Windows.Forms;
using System.Drawing;
using System;

namespace WindowsFormsApplication1 {
    /// <summary>
    /// PrintPreviewControlを継承し表示範囲をマウスで移動可能にしたクラス
    /// </summary>
    public class PrintPreviewControlEx : PrintPreviewControl {
        Point oldPosition;
        Point currentPosition;
        Type t;

        MethodInfo mInfo;
        FieldInfo fInfo;

        public override Cursor Cursor {
            get {
                return base.Cursor;
            }
            set {
                Cursor cursorHandOpen = new Cursor(Resource1.hand_open.Handle);
                base.Cursor = cursorHandOpen;
            }
        }

        public PrintPreviewControlEx() {
            this.AutoZoom = false;
            t = typeof(PrintPreviewControl);
            fInfo = t.GetField("position", (BindingFlags.Instance | (BindingFlags.NonPublic | BindingFlags.ExactBinding)));
            mInfo = t.GetMethod("SetPositionNoInvalidate", (BindingFlags.Instance | (BindingFlags.NonPublic | BindingFlags.ExactBinding)));
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);

            if(e.Button == MouseButtons.Left) {
                mInfo.Invoke(this,
                    new object[] { (currentPosition + (Size)(oldPosition - new Size(e.X, e.Y))) }
                    );
            }
            else {
                oldPosition = new Point(e.X, e.Y);
                currentPosition = ((Point)(fInfo.GetValue(this)));
            }
        }

        protected override void OnMouseDown(MouseEventArgs e) {
            base.OnMouseClick(e);
            Cursor cursorHandClose = new Cursor(Resource1.hand_close.Handle);
            Cursor.Current = cursorHandClose;
        }

        protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            Cursor cursorHandOpen = new Cursor(Resource1.hand_open.Handle);
            Cursor.Current = cursorHandOpen;
        }

        protected override void OnMouseHover(EventArgs e) {
            base.OnMouseHover(e);
            Cursor cursorHandOpen = new Cursor(Resource1.hand_open.Handle);
            Cursor.Current = cursorHandOpen;
        }
    }
}
