﻿using System.Collections.Generic;
using System.Windows.Forms;

namespace WindowsFormsApplication1 {
    /// <summary>
    /// データベースとdataGridViewの列の設定のクラス
    /// </summary>
    public class ColumnConfig {
        public string HeaderText { get; set; }
        public string Name { get; set; }
        public string unit { get; set; } = "";
        public int putPlaceNo { get; set; }
        public int Width { get; set; } = 100;
        public DataGridViewContentAlignment Alignment { get; set; }
        public string Format { get; set; } = "";
        public bool Visible { get; set; } = true;
        public string inputType { get; set; } = "";
        public string Items { get; set; }
        public bool limit { get; set; } = false;
        public double Minimum { get; set; }
        public double Maximum { get; set; }
        public bool statical { get; set; } = false;
        public string dbColumnType { get; set; } = "";
    }




    /// <summary>
    /// データベースとdataGridViewの列の設定を格納するクラス
    /// </summary>
    public static class ColumnsConfigSet {
        //列の設定のリストを取得
        public static List<ColumnConfig> getSet() {
            List<ColumnConfig> columnConfigs = new List<ColumnConfig>();
            ColumnConfig[] c = new ColumnConfig[100];

            int i = 0;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "id";
            c[i].Name = "id";
            c[i].putPlaceNo = 1;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].Visible = false;
            c[i].dbColumnType = "mk";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "管理者";
            c[i].Name = "kanrisya";
            c[i].putPlaceNo = 1;
            c[i].Alignment = DataGridViewContentAlignment.MiddleLeft;
            c[i].Visible = false;
            c[i].inputType = "TextBox";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "処理場";
            c[i].Name = "syorijou";
            c[i].putPlaceNo = 1;
            c[i].Alignment = DataGridViewContentAlignment.MiddleLeft;
            c[i].Visible = false;
            c[i].inputType = "TextBox";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "測定日";
            c[i].Name = "sokutei_dt";
            c[i].putPlaceNo = 1;
            c[i].Width = 95;
            c[i].Alignment = DataGridViewContentAlignment.MiddleCenter;
            c[i].Format = "yyyy/MM/dd ddd";
            c[i].inputType = "DateTimePicker";
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "天候";
            c[i].Name = "tenkou";
            c[i].putPlaceNo = 1;
            c[i].Width = 38;
            c[i].Alignment = DataGridViewContentAlignment.MiddleCenter;
            c[i].inputType = "ComboBox";
            c[i].Items = @"－－,晴,晴曇,晴雨,晴雪,曇,曇晴,曇雨,曇雪,雨,雨晴,雨曇,雨雪,雪,雪晴,雪曇,雪雨";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "気温";
            c[i].Name = "kion";
            c[i].unit = "[℃]";
            c[i].putPlaceNo = 1;
            c[i].Width = 38;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N1";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 99.9;
            c[i].Minimum = -99.9;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "雨量";
            c[i].Name = "uryou";
            c[i].unit = "[mm]";
            c[i].putPlaceNo = 1;
            c[i].Width = 52;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N1";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 9999.9;
            c[i].Minimum = 0;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "流入水量";
            c[i].Name = "wv_ryuunyuu";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 1;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "初沈流入量";
            c[i].Name = "wv_syochin";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 1;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "放流水量";
            c[i].Name = "wv_houryuu";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 1;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "初沈池容量";
            c[i].Name = "pv_syochin";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 2;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].statical = true;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "反応Ｔ容量";
            c[i].Name = "pv_airtank";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 3;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].statical = true;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "終沈池容量";
            c[i].Name = "pv_syuuchin";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 3;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].Format = "N0";
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].statical = true;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "塩混池容量";
            c[i].Name = "pv_enkon";
            c[i].unit = "[m3]";
            c[i].putPlaceNo = 1;
            c[i].Width = 75;
            c[i].Alignment = DataGridViewContentAlignment.MiddleRight;
            c[i].inputType = "NumericUpDown";
            c[i].limit = true;
            c[i].Maximum = 999999;
            c[i].Minimum = 0;
            c[i].Format = "N0";
            c[i].statical = true;
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            i++;
            c[i] = new ColumnConfig();
            c[i].HeaderText = "入力（インポート）日時";
            c[i].Name = "input_dt";
            c[i].putPlaceNo = 1;
            c[i].Width = 146;
            c[i].Alignment = DataGridViewContentAlignment.MiddleCenter;
            c[i].Format = "yyyy/MM/dd ddd HH:mm:ss";
            c[i].dbColumnType = "ix";
            columnConfigs.Add(c[i]);

            return columnConfigs;
        }




        //ヘッダーテキストから列名を取得
        public static string headerTextToName(string HeaderText) {
            List<ColumnConfig> ccSet = ColumnsConfigSet.getSet();

            foreach(ColumnConfig cc in ccSet) {
                if(cc.HeaderText == HeaderText) {
                    return cc.Name;
                }
            }

            return "";
        }
    }

}
