﻿// 下水データ管理システム
// Copyright (C) 2018 公益財団法人とちぎ建設技術センター(https://www.tochigictc.or.jp/)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.If not, see<http://www.gnu.org/licenses/>.

using System.Drawing.Printing;

namespace WindowsFormsApplication1 {
    public static class PrintProcess {
        /// <summary>
        /// 1論理ページごとに印刷処理するクラス
        /// </summary>
        static string printType;

        static int printPageCount;

        public static void setFirstPage() {
            printPageCount = 0;
        }

        public static bool goPrint(PrintPageEventArgs e, bool sameFrontPage = false) {
            printType = PrintContainer.printType;
            printPageCount++;
            bool hasMorePages;

            //印刷内容生成
            switch(printType) {
                case "Datalist":
                    hasMorePages = PrintDrawerDatalist.printDrawer(e.Graphics, printPageCount, sameFrontPage);
                    break;
                case "Graph":
                    hasMorePages = PrintDrawerGraph.printDrawer(e.Graphics);
                    break;
                default:
                    hasMorePages = false;
                    break;
            }

            //ページごとに複数印刷の場合ページカウントを戻す
            if(sameFrontPage) {
                printPageCount--;
                hasMorePages = true;
            }

            return hasMorePages;
        }

    }
}
