﻿// 下水データ管理システム
// Copyright (C) 2018 公益財団法人とちぎ建設技術センター(https://www.tochigictc.or.jp/)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.If not, see<http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;

namespace WindowsFormsApplication1 {
    public static class PrintDrawerDatalist {
        /// <summary>
        /// 1物理ページごとに印刷内容を出力するクラス（帳票印刷ページ）
        /// </summary>

        static int startRow { get; set; }

        static float printAreaWmm;
        static float printAreaHmm;
        static float printerMarginLmm;
        static float printerMarginTmm;

        static DataGridView dataGridView1;
        static ComboBox comboBox1;
        static ComboBox comboBox2;
        static List<int> printColumnsNo;
        
        static int totalWidth;
        static float mmPerPix;
        static float rowHeightmm;
        static float headerHeightmm;
        static float totalWidthmm;

        static Pen pen0;
        static Font font0;

        static RectangleF tRect;
        static StringFormat saML = new StringFormat();
        static StringFormat saMC = new StringFormat();
        static StringFormat saMR = new StringFormat();

        static string kanrisya;
        static string syorijou;
        static int cDtY;
        static int cDtM;
        static string yearMonth;

        //帳票印刷ページ
        public static bool printDrawer(Graphics g, int printPageCount, bool sameFrontPage = false) {
            //設定
            if(printPageCount == 1) {
                dataGridView1 = PrintContainer.dataGridView1;
                comboBox1 = PrintContainer.comboBox1;
                comboBox2 = PrintContainer.comboBox2;
                printColumnsNo = PrintContainer.printColumnsNo;
                totalWidth = PrintContainer.printWidth;

                startRow = 0;
                printAreaWmm = PrintArea.printAreaWmm;
                printAreaHmm = PrintArea.printAreaHmm;
                printerMarginLmm = PrintArea.printerMarginLmm;
                printerMarginTmm = PrintArea.printerMarginTmm;
                mmPerPix = printAreaWmm / totalWidth;
                totalWidthmm = totalWidth * mmPerPix;
                rowHeightmm = 21F * mmPerPix;
                headerHeightmm = 30F * mmPerPix;

                pen0 = new Pen(Color.Black, printAreaWmm * 0.001F);
                font0 = new Font("Meiryo UI", 11F * mmPerPix, GraphicsUnit.Millimeter);

                saML.Alignment = StringAlignment.Near;
                saML.LineAlignment = StringAlignment.Center;
                saMC.Alignment = StringAlignment.Center;
                saMC.LineAlignment = StringAlignment.Center;
                saMR.Alignment = StringAlignment.Far;
                saMR.LineAlignment = StringAlignment.Center;

                KanrisyaSyorijou item1 = (KanrisyaSyorijou)comboBox1.SelectedItem;
                kanrisya = item1.primaryKey(0);
                syorijou = item1.primaryKey(1);

                SelectableMonth item2 = (SelectableMonth)comboBox2.SelectedItem;
                cDtY = item2.primaryKey(0);
                cDtM = item2.primaryKey(1);

                if(cDtY > 0 && cDtM > 0) {
                    yearMonth = cDtY + "年" + cDtM + "月";
                }
                else {
                    yearMonth = "全期間";
                }
            }

            //以降mm単位で指定(実印刷サイズで指定)
            g.PageUnit = GraphicsUnit.Millimeter;
            g.TranslateTransform(printerMarginLmm, printerMarginTmm);
            g.SmoothingMode = SmoothingMode.AntiAlias;

            float rowTmm;
            float rowBmm;
            float itgWmm;

            //表題
            rowTmm = (0) * rowHeightmm;
            rowBmm = (1) * rowHeightmm;
            tRect = new RectangleF(0, rowTmm, totalWidthmm, rowHeightmm);
            g.DrawString(kanrisya + "　" + syorijou + "　" + yearMonth, font0, Brushes.Black, tRect, saML);

            //ページヘッダー
            rowTmm = (1) * rowHeightmm;
            rowBmm = (1) * rowHeightmm + headerHeightmm;
            itgWmm = 0;

            for(int j = 0; j <  dataGridView1.Columns.Count; j++) {
                if(j == 0) {
                    g.DrawLine(pen0, 0, rowTmm, totalWidthmm, rowTmm);
                    g.DrawLine(pen0, 0, rowTmm, 0, rowBmm);
                }

                if(printColumnsNo.Contains(j)) {
                    float cW = dataGridView1.Columns[j].Width * mmPerPix;
                    tRect = new RectangleF(itgWmm, rowTmm, cW, headerHeightmm);
                    g.DrawString(dataGridView1.Columns[j].HeaderText, font0, Brushes.Black, tRect, saMC);
                    g.DrawLine(pen0, itgWmm, rowTmm, itgWmm, rowBmm);
                    itgWmm += cW;
                }

                if(j == dataGridView1.Columns.Count - 1) {
                    g.DrawLine(pen0, itgWmm, rowTmm, itgWmm, rowBmm);
                }
            }

            //データ行
            bool rowEnd = false;

            for(int i = startRow; i < dataGridView1.RowCount; i++){
                rowTmm = (i - startRow + 1) * rowHeightmm + headerHeightmm;
                rowBmm = (i - startRow + 2) * rowHeightmm + headerHeightmm;
                itgWmm = 0;

                //改ページ判定
                if((i - startRow + 2) * rowHeightmm + headerHeightmm > printAreaHmm) {
                    g.DrawLine(pen0, 0, rowTmm, totalWidthmm, rowTmm);
                    rowEnd = true;

                    //前ページと同じ物を印刷しない場合（同一ページ複数印刷しないまたは複数印刷の最後の1枚）は開始行を進める
                    if(!sameFrontPage) {
                        startRow = i;
                    }

                    break;
                }

                //データ行
                for(int j = 0; j < dataGridView1.Columns.Count; j++) {
                    if(j == 0) {
                        g.DrawLine(pen0, 0, rowTmm, totalWidthmm, rowTmm);
                        g.DrawLine(pen0, 0, rowTmm, 0, rowBmm);
                    }

                    if(printColumnsNo.Contains(j)) {
                        float cW = dataGridView1.Columns[j].Width * mmPerPix;
                        string cA = dataGridView1.Columns[j].DefaultCellStyle.Alignment.ToString();
                        string cF = dataGridView1.Columns[j].DefaultCellStyle.Format.ToString();
                        string cV = dataGridView1.Rows[i].Cells[j].Value.ToString();
                        DateTime cVT;
                        decimal cVD;

                        if(cF=="yyyy/MM/dd ddd HH:mm:ss") {
                            if(DateTime.TryParse(cV,out cVT)) {
                                cV = cVT.ToString("yyyy/MM/dd ddd HH:mm:ss");
                            }
                        }
                        else if(cF == "yyyy/MM/dd ddd") {
                            if(DateTime.TryParse(cV, out cVT)) {
                                cV = cVT.ToString("yyyy/MM/dd ddd");
                            }
                        }
                        else if(decimal.TryParse(cV, out cVD)) {
                            if(cF == "N0") {
                                cV = cVD.ToString("#,0");
                            }
                            else if(cF == "N1") {
                                cV = cVD.ToString("#,0.0");
                            }
                            else if(cF == "N2") {
                                cV = cVD.ToString("#,0.00");
                            }
                            else if(cF == "N3") {
                                cV = cVD.ToString("#,0.000");
                            }
                            else if(cF == "N4") {
                                cV = cVD.ToString("#,0.0000");
                            }
                            else if(cF == "N5") {
                                cV = cVD.ToString("#,0.00000");
                            }
                            else {
                                cV = cVD.ToString();
                            }
                        }

                        tRect = new RectangleF(itgWmm, rowTmm, cW, rowHeightmm);

                        if(cA == "MiddleCenter") {
                            g.DrawString(cV, font0, Brushes.Black, tRect, saMC);
                        }
                        else if(cA == "MiddleRight") {
                            g.DrawString(cV, font0, Brushes.Black, tRect, saMR);
                        }
                        else {
                            g.DrawString(cV, font0, Brushes.Black, tRect, saML);
                        }

                        g.DrawLine(pen0, itgWmm, rowTmm, itgWmm, rowBmm);
                        itgWmm += cW;
                    }

                    if(j == dataGridView1.Columns.Count - 1) {
                        g.DrawLine(pen0, itgWmm, rowTmm, itgWmm, rowBmm);
                    }
                }

                //最終データ行
                if(i == dataGridView1.RowCount - 1) {
                    g.DrawLine(pen0, 0, rowBmm, totalWidthmm, rowBmm);
                }
            }

            //最終ページ判定
            if(!rowEnd) {
                return false;
            }
            else {
                return true;
            }
        }

    }
}
