﻿// 下水データ管理システム
// Copyright (C) 2018 公益財団法人とちぎ建設技術センター(https://www.tochigictc.or.jp/)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.If not, see<http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;
using System.Data.SQLite;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;

namespace WindowsFormsApplication1 {
    public static class PrintDrawerGraph {
        /// <summary>
        /// 1物理ページごとに印刷内容を出力するクラス（グラフ印刷ページ、1ページ限定）
        /// </summary>

        static float baseWidthmm = 246.126F;
        static float baseHeightmm = 159.258F;
        static float scaleW;
        static float scaleH;

        static RectangleF tRect;
        static StringFormat saML = new StringFormat();
        static StringFormat saMC = new StringFormat();
        static StringFormat saMR = new StringFormat();

        //グラフ印刷ページ
        public static bool printDrawer(Graphics g, bool forFile = false) {
            //設定
            DataGridView dataGridView1 = PrintContainer.dataGridView1;
            List<ColumnConfig> ccSet = ColumnsConfigSet.getSet;

            saML.Alignment = StringAlignment.Near;
            saML.LineAlignment = StringAlignment.Center;
            saMC.Alignment = StringAlignment.Center;
            saMC.LineAlignment = StringAlignment.Center;
            saMR.Alignment = StringAlignment.Far;
            saMR.LineAlignment = StringAlignment.Center;

            DateTime timeSpanSt = PrintContainer.timeSpanSt;
            DateTime timeSpanEd = PrintContainer.timeSpanEd;

            if(PrintContainer.monthAverage) {
                timeSpanEd = new DateTime(timeSpanEd.Year, timeSpanEd.Month, 1, 0, 0, 0);
            }

            TimeSpan timeSpan = timeSpanEd - timeSpanSt;
            int spanDays = timeSpan.Days + 1;
            int spanYears = timeSpanEd.Year - timeSpanSt.Year + 1;
            int spanMonths = (spanYears - 1) * 12 + (timeSpanEd.Month - timeSpanSt.Month + 1);

            //以降mm単位で指定(基準サイズA4で指定)
            scaleW = PrintArea.printAreaWmm / baseWidthmm;
            scaleH = PrintArea.printAreaHmm / baseHeightmm;

            g.PageUnit = GraphicsUnit.Millimeter;
            g.ScaleTransform(scaleW, scaleW);

            if(!forFile) {
                g.TranslateTransform(PrintArea.printerMarginLmm, PrintArea.printerMarginTmm);
            }
            else {
                g.TranslateTransform(PrintArea.printerMarginLmm / 4, PrintArea.printerMarginTmm / 4);
            }

            g.SmoothingMode = SmoothingMode.AntiAlias;

            Pen pen0 = new Pen(Color.Black, 0.1F);
            Pen pen1 = new Pen(Color.Red, 0.1F);

            Pen[] penSeries = new Pen[PrintContainer.graphSeriesNo];

            if(PrintContainer.colorPrint) {
                penSeries[1] = new Pen(Color.FromArgb(255, 0, 0), 0.5F);

                penSeries[2] = new Pen(Color.FromArgb(50, 50, 255), 0.5F);

                penSeries[3] = new Pen(Color.FromArgb(255, 150, 0), 0.5F);

                penSeries[4] = new Pen(Color.FromArgb(0, 200, 0), 0.5F);

                penSeries[5] = new Pen(Color.FromArgb(255, 150, 150), 0.5F);

                penSeries[6] = new Pen(Color.FromArgb(200, 0, 255), 0.5F);
            }
            else {
                penSeries[1] = new Pen(Color.Black, 0.5F);
                penSeries[1].DashStyle = DashStyle.Solid;

                penSeries[2] = new Pen(Color.Black, 0.5F);
                penSeries[2].DashStyle = DashStyle.Dash;

                penSeries[3] = new Pen(Color.Black, 0.5F);
                penSeries[3].DashStyle = DashStyle.Dot;

                penSeries[4] = new Pen(Color.Black, 0.5F);
                penSeries[4].DashStyle = DashStyle.DashDot;

                penSeries[5] = new Pen(Color.Black, 0.5F);
                penSeries[5].DashStyle = DashStyle.DashDotDot;

                penSeries[6] = new Pen(Color.Black, 0.5F);
                penSeries[6].DashPattern = new float[] { 3F, 1F, 1F, 1F, 1F, 1F, 1F, 1F };
            }
            
            Font font20 = new Font("Meiryo UI", 2F, GraphicsUnit.Millimeter);
            Font font25 = new Font("Meiryo UI", 2.5F, GraphicsUnit.Millimeter);
            Font font30 = new Font("Meiryo UI", 3F, GraphicsUnit.Millimeter);

            //印刷内容生成
            //外枠
            g.DrawRectangle(pen0, 3F, 0F, 243.126F, 149.258F);
            g.DrawLine(pen0, 213.126F, 0, 213.126F, 149.258F);

            for(int i = 1; i < PrintContainer.graphSeriesNo - 1; i++) {
                g.DrawLine(pen0, 213.126F, (149.258F / 6F) * i, 246.126F, (149.258F / 6F) * i);
            }

            //横軸（日付）
            for(int d = 0; d < spanDays; d++) {
                DateTime cDate = timeSpanSt.AddDays(d);
                float pX = d * 210.126F / (spanDays - 1) + 3F;

                if(spanDays < 63) {
                    g.DrawLine(pen0, pX, 149.258F, pX, 150.258F);

                    tRect = new RectangleF(0F, 0F, 10F, 4.6F);
                    g.RotateTransform(-90F);
                    g.TranslateTransform(-150.258F - 10.5F, pX - 2.3F);

                    if(d == 0 || (cDate.Month == 1 && cDate.Day == 1)) {
                        g.DrawString((timeSpanSt.AddDays(d)).ToString("yyyy\nM/d"), font20, Brushes.Black, tRect, saMR);
                    }
                    else if(cDate.Day == 1) {
                        g.DrawString((timeSpanSt.AddDays(d)).ToString("M/d"), font20, Brushes.Black, tRect, saMR);
                    }
                    else {
                        g.DrawString((timeSpanSt.AddDays(d)).ToString("%d"), font20, Brushes.Black, tRect, saMR);
                    }

                    g.TranslateTransform(150.258F + 10.5F, -pX + 2.3F);
                    g.RotateTransform(90F);
                }
                else if(spanDays < 185) {
                    if(cDate.Day == 1 || cDate.Day == 5 || cDate.Day == 10 || cDate.Day == 15 || cDate.Day == 20 || cDate.Day == 25 || d + 1 == spanDays) {
                        g.DrawLine(pen0, pX, 149.258F, pX, 150.258F);

                        tRect = new RectangleF(0F, 0F, 10F, 4.6F);
                        g.RotateTransform(-90F);
                        g.TranslateTransform(-150.258F - 10.5F, pX - 2.3F);

                        if(d == 0 || (cDate.Month == 1 && cDate.Day == 1)) {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("yyyy\nM/d"), font20, Brushes.Black, tRect, saMR);
                        }
                        else if(cDate.Day == 1) {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("M/d"), font20, Brushes.Black, tRect, saMR);
                        }
                        else {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("%d"), font20, Brushes.Black, tRect, saMR);
                        }

                        g.TranslateTransform(150.258F + 10.5F, -pX + 2.3F);
                        g.RotateTransform(90F);
                    }
                }
                else if(spanDays < 367 && !PrintContainer.monthAverage) {
                    if(cDate.Day == 1 || cDate.Day == 10 || cDate.Day == 20 || d + 1 == spanDays) {
                        g.DrawLine(pen0, pX, 149.258F, pX, 150.258F);

                        tRect = new RectangleF(0F, 0F, 10F, 4.6F);
                        g.RotateTransform(-90F);
                        g.TranslateTransform(-150.258F - 10.5F, pX - 2.3F);

                        if(d == 0 || (cDate.Month == 1 && cDate.Day == 1)) {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("yyyy\nM/d"), font20, Brushes.Black, tRect, saMR);
                        }
                        else if(cDate.Day == 1) {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("M/d"), font20, Brushes.Black, tRect, saMR);
                        }
                        else {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("%d"), font20, Brushes.Black, tRect, saMR);
                        }

                        g.TranslateTransform(150.258F + 10.5F, -pX + 2.3F);
                        g.RotateTransform(90F);
                    }
                }
                else {
                    if(cDate.Day == 1 || d + 1 == spanDays) {
                        g.DrawLine(pen0, pX, 149.258F, pX, 150.258F);

                        tRect = new RectangleF(0F, 0F, 10F, 4.6F);
                        g.RotateTransform(-90F);
                        g.TranslateTransform(-150.258F - 10.5F, pX - 2.3F);

                        if(d == 0 || (cDate.Month == 1 && cDate.Day == 1)) {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("yyyy/M"), font20, Brushes.Black, tRect, saMR);
                        }
                        else if(cDate.Day == 1) {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("%M"), font20, Brushes.Black, tRect, saMR);
                        }
                        else {
                            g.DrawString((timeSpanSt.AddDays(d)).ToString("M/d"), font20, Brushes.Black, tRect, saMR);
                        }

                        g.TranslateTransform(150.258F + 10.5F, -pX + 2.3F);
                        g.RotateTransform(90F);
                    }
                }
            }

            //測定値のレンジ設定
            bool[] seriesNA = new bool[PrintContainer.graphSeriesNo];
            bool[] seriesScaleMaster = new bool[PrintContainer.graphSeriesNo];
            bool[] seriesScaleSlave = new bool[PrintContainer.graphSeriesNo];
            decimal?[] seriesMin = new decimal?[PrintContainer.graphSeriesNo];
            decimal?[] seriesMax = new decimal?[PrintContainer.graphSeriesNo];
            decimal[] seriesMeasureMin = new decimal[PrintContainer.graphSeriesNo];
            decimal[] seriesMeasureMax = new decimal[PrintContainer.graphSeriesNo];
            decimal[] correction = new decimal[PrintContainer.graphSeriesNo];

            for(int i = 1; i < PrintContainer.graphSeriesNo; i++) {
                if(PrintContainer.graphSerieses[i].kanrisya != null && !seriesScaleSlave[i]) {
                    for(int j = i; j < PrintContainer.graphSeriesNo; j++) {
                        if(PrintContainer.graphSerieses[j].scaleNo == i) {
                            using(var con = new SQLiteConnection(DataBaseConfig.ConnectionString)) {
                                con.Open();
                                using(var cmd = con.CreateCommand()) {
                                    cmd.CommandText = "SELECT MIN(" + ccSet[PrintContainer.graphSerieses[j].columnsIndex].Name + ") AS min, MAX(" + ccSet[PrintContainer.graphSerieses[j].columnsIndex].Name + ") AS max FROM suishitsu_kanri WHERE kanrisya='" + PrintContainer.graphSerieses[j].kanrisya + "' AND syorijou='" + PrintContainer.graphSerieses[j].syorijou + "' AND sokutei_dt>='" + PrintContainer.timeSpanSt.ToString("yyyy-MM-dd 00:00:00") + "' AND sokutei_dt<'" + PrintContainer.timeSpanEd.AddDays(1).ToString("yyyy-MM-dd 00:00:00") + "' AND del_flg IS NULL;";
                                    using(var reader = cmd.ExecuteReader()) {
                                        if(reader.Read()) {
                                            if(!reader.IsDBNull(0)) {
                                                if(seriesMin[i] == null) {
                                                    seriesMin[i] = reader.GetDecimal(0);
                                                }
                                                else {
                                                    if(reader.GetDecimal(0) < seriesMin[i]) {
                                                        seriesMin[i] = reader.GetDecimal(0);
                                                    }
                                                }
                                            }

                                            if(!reader.IsDBNull(1)) {
                                                if(seriesMax[i] == null) {
                                                    seriesMax[i] = reader.GetDecimal(1);
                                                }
                                                else {
                                                    if(reader.GetDecimal(1) > seriesMax[i]) {
                                                        seriesMax[i] = reader.GetDecimal(1);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            if(j != i) {
                                seriesScaleSlave[j] = true;
                            }
                        }
                    }

                    if(seriesMin[i] == null || seriesMax[i] == null) {
                        seriesNA[i] = true;
                    }
                    else {
                        seriesMin[i] = FunctionForDatabase.decConvFromDB(seriesMin[i], ccSet[PrintContainer.graphSerieses[i].columnsIndex].Format);
                        seriesMax[i] = FunctionForDatabase.decConvFromDB(seriesMax[i], ccSet[PrintContainer.graphSerieses[i].columnsIndex].Format);

                        if(seriesMin[i] == 0 && seriesMax[i] == 0) {
                            seriesMin[i] = 0.0M;
                            seriesMax[i] = 1.0M;
                        }
                    }

                    seriesScaleMaster[i] = true;
                }
            }

            //最小最大目盛設定
            for(int i = 1; i < PrintContainer.graphSeriesNo; i++) {
                if(seriesNA[i]) {
                    continue;
                }

                if(seriesScaleMaster[i]) {
                    string minus;
                    string correctionString;
                    int enableMeasure;
                    decimal correctionMin = 0;

                    //最小目盛
                    minus = "";
                    correctionString = "";
                    enableMeasure = 0;

                    if(seriesMin[i] > 0) {
                        seriesMeasureMin[i] = 0;
                    }
                    else {
                        string seriesMinString = seriesMin[i].ToString();

                        if(seriesMinString[0] == '-') {
                            seriesMinString = seriesMinString.Replace("-", string.Empty);
                            minus = "-";
                        }

                        string seriesMeasureMinString = "";

                        if(seriesMinString[0] == '0') {
                            seriesMeasureMinString += "0.";
                            correctionString += "0.";

                            for(int j = 2; j < seriesMinString.Length; j++) {
                                char c = seriesMinString[j];

                                if(c != '0') {
                                    enableMeasure++;
                                }

                                seriesMeasureMinString += c;

                                if(enableMeasure == 2) {
                                    correctionString += '1';
                                    break;
                                }
                                else {
                                    correctionString += '0';
                                }
                            }
                        }
                        else {
                            foreach(char c in seriesMinString) {
                                if(c == '.') {
                                    seriesMeasureMinString += '.';
                                    correctionString += '.';
                                }
                                else {
                                    enableMeasure++;

                                    if(enableMeasure < 2) {
                                        seriesMeasureMinString += c;
                                        correctionString += '0';
                                    }
                                    else if(enableMeasure == 2) {
                                        seriesMeasureMinString += c;
                                        correctionString += '1';
                                    }
                                    else {
                                        seriesMeasureMinString += '0';
                                        correctionString += '0';
                                    }
                                }
                            }
                        }

                        if(enableMeasure < 2) {
                            correctionString += '1';
                        }

                        seriesMeasureMin[i] = decimal.Parse(minus + seriesMeasureMinString);
                        correctionMin = decimal.Parse(correctionString);
                    }

                    //最大目盛
                    minus = "";
                    correctionString = "";
                    enableMeasure = 0;
                    decimal correctionMax = 0;

                    if(seriesMax[i] < 0) {
                        seriesMeasureMax[i] = 0;
                    }
                    else {
                        string seriesMaxString = seriesMax[i].ToString();

                        if(seriesMaxString[0] == '-') {
                            seriesMaxString = seriesMaxString.Replace("-", string.Empty);
                            minus = "-";
                        }

                        string seriesMeasureMaxString = "";

                        if(seriesMaxString[0] == '0') {
                            seriesMeasureMaxString += "0.";
                            correctionString += "0.";

                            for(int j = 2; j < seriesMaxString.Length; j++) {
                                char c = seriesMaxString[j];

                                if(c != '0') {
                                    enableMeasure++;
                                }

                                seriesMeasureMaxString += c;

                                if(enableMeasure == 2) {
                                    correctionString += '1';
                                    break;
                                }
                                else {
                                    correctionString += '0';
                                }
                            }
                        }
                        else {
                            foreach(char c in seriesMaxString) {
                                if(c == '.') {
                                    seriesMeasureMaxString += '.';
                                    correctionString += '.';
                                }
                                else {
                                    enableMeasure++;

                                    if(enableMeasure < 2) {
                                        seriesMeasureMaxString += c;
                                        correctionString += '0';
                                    }
                                    else if(enableMeasure == 2) {
                                        seriesMeasureMaxString += c;
                                        correctionString += '1';
                                    }
                                    else {
                                        seriesMeasureMaxString += '0';
                                        correctionString += '0';
                                    }
                                }
                            }
                        }

                        if(enableMeasure < 2) {
                            correctionString += '1';
                        }

                        seriesMeasureMax[i] = decimal.Parse(minus + seriesMeasureMaxString);
                        correctionMax = decimal.Parse(correctionString);
                    }

                    if(correctionMin > correctionMax) {
                        correction[i] = correctionMin;
                    }
                    else {
                        correction[i] = correctionMax;
                    }

                    if(seriesMeasureMin[i] != 0) {
                        seriesMeasureMin[i] = Math.Truncate((seriesMeasureMin[i] - correction[i]) / correction[i]) * correction[i];
                    }

                    if(seriesMeasureMax[i] != 0) {
                        seriesMeasureMax[i] = Math.Truncate((seriesMeasureMax[i] + correction[i]) / correction[i]) * correction[i];
                    }
                }
                else {
                    seriesMeasureMin[i] = seriesMeasureMin[PrintContainer.graphSerieses[i].scaleNo];
                    seriesMeasureMax[i] = seriesMeasureMax[PrintContainer.graphSerieses[i].scaleNo];
                    correction[i] = correction[PrintContainer.graphSerieses[i].scaleNo];
                }
            }

            //縦軸
            float axisYWidth = 12F;

            int axisYNo = 1;
            for(int i = 1; i < PrintContainer.graphSeriesNo; i++) {
                if(seriesScaleMaster[i]) {
                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 0, 213.126F - axisYNo * axisYWidth, 149.258F);

                    if(seriesNA[i]) {
                        g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 0F, 214.126F - axisYNo * axisYWidth, 0F);
                        tRect = new RectangleF(214.126F - axisYNo * axisYWidth, - 1.0F, 10F, 4.6F);
                        g.DrawString("N/A", font20, Brushes.Black, tRect, saML);

                        axisYNo++;
                        continue;
                    }

                    int maxStep = (int)Math.Abs(Math.Round((seriesMeasureMax[i] - seriesMeasureMin[i]) / correction[i]));

                    if(seriesMeasureMin[i] == 0 || seriesMeasureMax[i] == 0) {
                        //零点が上限または下限
                        for(int j = 0; j <= maxStep; j++) {
                            if(j == 0) {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 3.5F, 10F, 4.6F);
                                g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                            else if(j == maxStep) {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 1.0F, 10F, 4.6F);
                                g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                            else if(seriesMeasureMin[i] + correction[i] * j == 0) {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                            else {
                                if(maxStep > 60) {
                                    if(j % 10 == 0) {
                                        g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                        tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                        g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                    }
                                }
                                else if(maxStep > 30) {
                                    if(j % 5 == 0) {
                                        g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                        tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                        g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                    }
                                }
                                else if(maxStep > 15) {
                                    if(j % 2 == 0) {
                                        g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                        tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                        g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                    }
                                }
                                else {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                        }
                    }
                    else {
                        //零点が中間
                        float zeroPointY = 149.258F;

                        for(int j = 0; j <= maxStep; j++) {
                            if(j == 0) {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 3.5F, 10F, 4.6F);
                                g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                            else if(j == maxStep) {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 1.0F, 10F, 4.6F);
                                g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                            else if(seriesMeasureMin[i] + correction[i] * j == 0) {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, 149.258F - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                g.DrawString((seriesMeasureMin[i] + correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                zeroPointY = 149.258F - 149.258F / maxStep * j;
                            }
                        }

                        for(int j = 1; j > 0; j++) {
                            if(correction[i] * j >= seriesMeasureMax[i]) {
                                break;
                            }

                            if(maxStep > 60) {
                                if(j % 10 == 0) {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                            else if(maxStep > 30) {
                                if(j % 5 == 0) {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                            else if(maxStep > 15) {
                                if(j % 2 == 0) {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                            else {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                        }

                        for(int j =  - 1; j < 0; j--) {
                            if(correction[i] * j <= seriesMeasureMin[i]) {
                                break;
                            }

                            if(maxStep > 60) {
                                if(j % 10 == 0) {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                            else if(maxStep > 30) {
                                if(j % 5 == 0) {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                            else if(maxStep > 15) {
                                if(j % 2 == 0) {
                                    g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                    tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                    g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                                }
                            }
                            else {
                                g.DrawLine(pen0, 213.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j, 214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j);
                                tRect = new RectangleF(214.126F - axisYNo * axisYWidth, zeroPointY - 149.258F / maxStep * j - 2.3F, 10F, 4.6F);
                                g.DrawString((correction[i] * j).ToString("#,0.######"), font20, Brushes.Black, tRect, saML);
                            }
                        }
                    }

                    axisYNo++;
                }
            }

            //系統ラベル
            axisYNo = 1;
            for(int i = 1; i < PrintContainer.graphSeriesNo; i++) {
                if(seriesScaleMaster[i]) {
                    int seriesCount = 0;
                    for(int j = i; j < PrintContainer.graphSeriesNo; j++) {
                        if(PrintContainer.graphSerieses[j].scaleNo == i) {
                            g.FillRectangle(Brushes.White, 213.126F - axisYNo * axisYWidth - 2.5F, 3F * seriesCount, 2.5F, 2.5F);
                            g.DrawRectangle(pen0, 213.126F - axisYNo * axisYWidth - 2.5F, 3F * seriesCount, 2.5F, 2.5F);
                            tRect = new RectangleF(213.126F - axisYNo * axisYWidth - 2.5F, 3F * seriesCount, 2.5F, 2.5F);
                            g.DrawString(j.ToString(), font20, Brushes.Black, tRect, saMC);
                            seriesCount++;
                        }
                    }

                    axisYNo++;
                }
            }

            //凡例
            for(int i = 1; i < PrintContainer.graphSeriesNo; i++) {
                if(PrintContainer.graphSerieses[i].scaleNo > 0) {
                    g.DrawRectangle(pen0, 213.126F, (149.258F / 6F) * (i - 1), 4F, 4F);
                    tRect = new RectangleF(213.126F, (149.258F / 6F) * (i - 1), 4F, 4F);
                    g.DrawString(i.ToString(), font30, Brushes.Black, tRect, saMC);
                    g.DrawLine(penSeries[i], 223.126F, (149.258F / 6F) * (i - 1) + 2F, 240.126F, (149.258F / 6F) * (i - 1) + 2F);

                    tRect = new RectangleF(213.126F, (149.258F / 6F) * (i - 1) + 4F, 30F, ((149.258F / 6F - 4F) / 5F));
                    g.DrawString(ccSet[PrintContainer.graphSerieses[i].columnsIndex].HeaderText + ccSet[PrintContainer.graphSerieses[i].columnsIndex].unit, font25, Brushes.Black, tRect, saML);

                    tRect = new RectangleF(213.126F, (149.258F / 6F) * (i - 1) + ((149.258F / 6F - 4F) / 5F) * 2, 30F, ((149.258F / 6F - 4F) / 5F));
                    g.DrawString(PrintContainer.graphSerieses[i].kanrisya, font25, Brushes.Black, tRect, saML);

                    tRect = new RectangleF(213.126F, (149.258F / 6F) * (i - 1) + ((149.258F / 6F - 4F) / 5F) * 3, 30F, ((149.258F / 6F - 4F) / 5F));
                    g.DrawString(PrintContainer.graphSerieses[i].syorijou, font25, Brushes.Black, tRect, saML);
                }
            }

            tRect = new RectangleF(215.126F, 149.758F, 20F, 4F);

            if(!PrintContainer.monthAverage) {
                g.DrawString("（日単位）", font25, Brushes.Black, tRect, saML);
            }
            else {
                g.DrawString("（月平均）", font25, Brushes.Black, tRect, saML);
            }

            //折線
            for(int i = 1; i < PrintContainer.graphSeriesNo; i++) {
                if(seriesNA[i]) {
                    continue;
                }

                List<PointF> pointList = new List<PointF>();

                if(!PrintContainer.monthAverage) {
                    //日単位
                    using(var con = new SQLiteConnection(DataBaseConfig.ConnectionString)) {
                        con.Open();
                        using(var cmd = con.CreateCommand()) {
                            cmd.CommandText = "SELECT sokutei_dt, " + ccSet[PrintContainer.graphSerieses[i].columnsIndex].Name + " AS value1 FROM suishitsu_kanri WHERE kanrisya='" + PrintContainer.graphSerieses[i].kanrisya + "' AND syorijou='" + PrintContainer.graphSerieses[i].syorijou + "' AND sokutei_dt>='" + timeSpanSt.ToString("yyyy-MM-dd 00:00:00") + "' AND sokutei_dt<'" + timeSpanEd.AddDays(1).ToString("yyyy-MM-dd 00:00:00") + "' AND del_flg IS NULL ORDER BY sokutei_dt;";
                            using(var reader = cmd.ExecuteReader()) {
                                while(reader.Read()) {
                                    if(!reader.IsDBNull(1)) {
                                        DateTime sokutei_dt = reader.GetDateTime(0);
                                        TimeSpan dateDiff = sokutei_dt - timeSpanSt;

                                        decimal value1 = reader.GetDecimal(1);

                                        value1 = (decimal)FunctionForDatabase.decConvFromDB(value1, ccSet[PrintContainer.graphSerieses[i].columnsIndex].Format);

                                        float pX = (float)dateDiff.TotalDays * 210.126F / (spanDays - 1) + 3F;
                                        float pY = 149.258F - 149.258F * ((float)(value1 - seriesMeasureMin[i]) / (float)(seriesMeasureMax[i] - seriesMeasureMin[i]));
                                        pointList.Add(new PointF(pX, pY));
                                    }
                                }
                            }
                        }
                    }
                }
                else {
                    //月平均
                    for(DateTime cDate = PrintContainer.timeSpanSt; cDate <= timeSpanEd; cDate = cDate.AddMonths(1)) {
                        using(var con = new SQLiteConnection(DataBaseConfig.ConnectionString)) {
                            con.Open();
                            using(var cmd = con.CreateCommand()) {
                                cmd.CommandText = "SELECT AVG(" + ccSet[PrintContainer.graphSerieses[i].columnsIndex].Name + ") AS value1 FROM suishitsu_kanri WHERE kanrisya='" + PrintContainer.graphSerieses[i].kanrisya + "' AND syorijou='" + PrintContainer.graphSerieses[i].syorijou + "' AND sokutei_dt>='" + cDate.ToString("yyyy-MM-dd 00:00:00") + "' AND sokutei_dt<'" + cDate.AddMonths(1).ToString("yyyy-MM-dd 00:00:00") + "' AND del_flg IS NULL;";
                                using(var reader = cmd.ExecuteReader()) {
                                    if(reader.Read()) {
                                        if(!reader.IsDBNull(0)) {
                                            decimal value1 = reader.GetDecimal(0);

                                            value1 = (decimal)FunctionForDatabase.decConvFromDB(value1, ccSet[PrintContainer.graphSerieses[i].columnsIndex].Format);

                                            TimeSpan d = cDate - PrintContainer.timeSpanSt;
                                            float pX = d.Days * 210.126F / (spanDays - 1) + 3F;
                                            float pY = 149.258F - 149.258F * ((float)(value1 - seriesMeasureMin[i]) / (float)(seriesMeasureMax[i] - seriesMeasureMin[i]));
                                            pointList.Add(new PointF(pX, pY));
                                        }
                                    }
                                }
                            }
                        }

                    }
                }

                PointF[] pointArrey = pointList.ToArray();

                if(pointArrey.Length > 1) {
                    g.DrawLines(penSeries[i], pointArrey);
                }
                else if(pointArrey.Length == 1) {
                    Brush newBrush = new SolidBrush(penSeries[i].Color);

                    g.FillEllipse(newBrush, pointArrey[0].X - 0.5F, pointArrey[0].Y - 0.5F, 1F, 1F);
                }
            }

            return false;
        }
    }
}
