﻿// 下水データ管理システム
// Copyright (C) 2018 公益財団法人とちぎ建設技術センター(https://www.tochigictc.or.jp/)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.If not, see<http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data.SQLite;
using System.Drawing;
using System.Windows.Forms;

namespace WindowsFormsApplication1 {
    public partial class Form32z1SettingSeries : Form {
        public Form32z1SettingSeries() {
            InitializeComponent();
        }


        public int series { get; set; }
        public graphSeries[] graphSerieses = new graphSeries[PrintContainer.graphSeriesNo];
        public bool deletable { get; set; }
        public bool chenged { get; set; }
        public bool deleted { get; set; }

        List<ColumnConfig> ccSet = ColumnsConfigSet.getSet;

        BindingList<KanrisyaSyorijou> KSCBItem = new BindingList<KanrisyaSyorijou>();




        //ロード時イベント
        private void Form32z1SettingSeries_Load(object sender, EventArgs e) {
            this.Text = "系統" + series.ToString() + "の設定";

            if(deletable) {
                putDeleteButton();
            }

            kanrisyaSyorijouSet(graphSerieses[series].kanrisya, graphSerieses[series].syorijou);
            dataKoumokuSet(graphSerieses[series].columnsIndex);
            scaleSet();
            this.ActiveControl = button2;
        }




        //データ項目ボックス設定
        private void dataKoumokuSet(int selectedColumnsIndex = 0) {
            comboBox1.BeginUpdate();

            int i = 0;
            int c = 0;
            foreach(ColumnConfig cc in ccSet) {
                if(cc.inputType == "NumericUpDown" || cc.calculatedDecimal) {
                    comboBox1.Items.Add(cc.HeaderText + cc.unit);

                    if(cc.index == selectedColumnsIndex) {
                        c = i;
                    }

                    i++;
                }
            }

            if(i > 0) {
                comboBox1.Enabled = true;
                comboBox1.SelectedIndex = c;
            }

            comboBox1.EndUpdate();
        }




        //管理者・処理場選択ボックス設定
        private void kanrisyaSyorijouSet(string selectedKanrisya = null, string selectedSyorijou = null) {
            comboBox2.DisplayMember = "selectionName";
            comboBox2.ValueMember = "primaryKey";
            comboBox2.DataSource = KSCBItem;
            comboBox2.BeginUpdate();
            KSCBItem.Clear();

            using(var con = new SQLiteConnection(DataBaseConfig.ConnectionString)) {
                con.Open();

                using(var cmd = con.CreateCommand()) {
                    cmd.CommandText = "SELECT t1.kanrisya, t1.syorijou, t2.ck FROM suishitsu_kanri AS t1 " +
                        "INNER JOIN (SELECT kanrisya, COUNT(kanrisya) AS ck FROM suishitsu_kanri GROUP BY kanrisya) AS t2 ON t1.kanrisya=t2.kanrisya " +
                        "GROUP BY t1.kanrisya, t1.syorijou ORDER BY t2.ck DESC, COUNT(t1.syorijou) DESC";

                    using(var reader = cmd.ExecuteReader()) {
                        int i = 0;
                        int c = 0;
                        while(reader.Read()) {
                            string kanrisya = reader.GetString(0);
                            string syorijou = reader.GetString(1);
                            KSCBItem.Add(new KanrisyaSyorijou(kanrisya, syorijou));

                            if(kanrisya == selectedKanrisya && syorijou == selectedSyorijou) {
                                c = i;
                            }

                            i++;
                        }
                        
                        if(i > 0) {
                            comboBox2.Enabled = true;
                            comboBox2.SelectedIndex = c;
                        }
                    }
                }
            }
            comboBox2.EndUpdate();
        }




        //スケール選択ボックス設定
        private void scaleSet() {
            comboBox3.BeginUpdate();
            comboBox3.Items.Clear();
            comboBox3.Items.Add("このデータ");

            int c = 0;
            bool cSeted = false;

            if(series != 1) {
                int optionCount = 0;
                for(int i = 1; i < series; i++) {
                    string dataKoumoku = (string)comboBox1.SelectedItem;

                    if(ColumnsConfigSet.headerTextAndUnitToIndex(dataKoumoku) > -1) {
                        if(ccSet[ColumnsConfigSet.headerTextAndUnitToIndex(dataKoumoku)].unit == ccSet[graphSerieses[i].columnsIndex].unit) {
                            if(graphSerieses[i].scaleNo == i) {
                                string sameScaleStr = "";

                                for(int j = i + 1; j < series; j++) {
                                    if(graphSerieses[j].scaleNo == i) {
                                        sameScaleStr += "," + j.ToString();
                                    }
                                }

                                if(i == graphSerieses[series].scaleNo) {
                                    if(!cSeted) {
                                        c = optionCount + 1;
                                        cSeted = true;
                                    }
                                }

                                comboBox3.Items.Add("系統" + i.ToString() + sameScaleStr + "と同じスケール");
                                optionCount++;
                            }
                        }
                    }
                }
            }

            if(graphSerieses[series].scaleNo == series) {
                c = 0;
            }

            comboBox3.SelectedIndex = c;
            comboBox3.EndUpdate();
        }




        //削除するボタン配置
        private void putDeleteButton() {
            Button newButton = new Button();
            newButton.BackColor = Color.White;
            newButton.Location = new Point(191, 10);
            newButton.Size = new Size(85, 25);
            newButton.Text = "削除する";
            newButton.UseVisualStyleBackColor = false;

            newButton.Click += new EventHandler(buttonDelete_Click);

            this.Controls.Add(newButton);
        }




        //データ項目ボックス変更イベント
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e) {
            scaleSet();
        }




        //設定するボタンクリックイベント
        private void button1_Click(object sender, EventArgs e) {
            KanrisyaSyorijou item1 = (KanrisyaSyorijou)comboBox2.SelectedItem;
            graphSerieses[series].kanrisya = item1.primaryKey(0);
            graphSerieses[series].syorijou = item1.primaryKey(1);

            string dataKoumoku = (string)comboBox1.SelectedItem;

            if(ColumnsConfigSet.headerTextAndUnitToIndex(dataKoumoku) > -1) {
                graphSerieses[series].columnsIndex = ColumnsConfigSet.headerTextAndUnitToIndex(dataKoumoku);
            }

            string scaleKeitou = (string)comboBox3.SelectedItem;

            if(scaleKeitou == "このデータ") {
                graphSerieses[series].scaleNo = series;
            }
            else {
                graphSerieses[series].scaleNo = int.Parse(scaleKeitou.Substring(2, 1));
            }

            chenged = true;
            this.Close();
        }
        



        //削除するボタンクリックイベント
        private void buttonDelete_Click(object sender, EventArgs e) {
            deleted = true;
            this.Close();
        }




        //キャンセルボタンクリックイベント
        private void button2_Click(object sender, EventArgs e) {
            this.Close();
        }

    }
}
